<?php
ini_set('max_execution_time', 0);
ini_set('memory_limit', '512M');
ignore_user_abort(true);

function get_extension($path) {
    return pathinfo($path, PATHINFO_EXTENSION);
}

function find_max_serial_root($base, $folder) {
    $max = 0;
    if (!is_dir($base)) return 0;
    foreach (scandir($base) as $file) {
        if (preg_match('/^' . preg_quote($folder, '/') . '(\d+)\.php$/', $file, $m)) {
            $num = (int)$m[1];
            if ($num > $max) $max = $num;
        }
    }
    return $max;
}

function build_link($domain, $filename) {
    return "https://$domain/$filename";
}

// ================= CONFIG =================
$domains = [
    'bkbing.com' => [
        'base' => '/home/zegoogle/bkbing.com/',
        'folders' => [
            'fbfeed'   => 'fbfeed.php',
            'insta'    => 'insta.php',
            'reel'     => 'reel.php',
            'fblive'   => 'fblive.php',
            'trending' => 'trending.php',
            'x'        => 'x.php',
            'tiktok'   => 'tiktok.php'
        ]
    ],
];
// ==========================================

$results = [];
$errors = [];
$copies = isset($_POST['copies']) ? max(1, (int)$_POST['copies']) : 1;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($domains as $domain => $info) {
        $base = rtrim($info['base'], '/') . '/';
        $results[$domain] = [];

        foreach ($info['folders'] as $folder => $sourceFile) {
            $source = $base . $folder . '/' . $sourceFile;

            if (!file_exists($source)) {
                $errors[] = "Missing source: $source";
                continue;
            }

            $last = find_max_serial_root($base, $folder);
            $start = $last + 1;

            for ($i = $start; $i < $start + $copies; $i++) {
                $filename = $folder . $i . '.php'; // e.g. reel12.php
                $dest = $base . $filename;

                if (@copy($source, $dest)) {
                    $results[$domain][] = build_link($domain, $filename);
                } else {
                    $errors[] = "Failed to copy to: $dest";
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Multi-Domain Auto Copy</title>
  <style>
    body { font-family: sans-serif; background: #f5f5f5; padding: 20px; }
    .container { max-width: 900px; background: #fff; padding: 20px; margin: auto; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.05); }
    input, button { padding: 10px; margin-top: 5px; width: 100%; font-size: 16px; }
    button { background: #111; color: #fff; border: none; cursor: pointer; border-radius: 6px; }
    textarea { width: 100%; height: 160px; margin-top: 10px; font-family: monospace; }
    h3 { margin-top: 30px; }
    .error { background: #ffe6e6; padding: 10px; margin-top: 10px; border-left: 5px solid #c00; }
  </style>
</head>
<body>
<div class="container">
  <h2>Multi-Domain Auto Copy</h2>
  <form method="post">
    <label>How many new landing pages to create per folder?</label>
    <input type="number" name="copies" min="1" value="<?= htmlspecialchars($copies) ?>">
    <button type="submit">Generate</button>
  </form>

  <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
    <?php if (!empty($results)): ?>
      <?php foreach ($results as $domain => $links): ?>
        <h3><?= htmlspecialchars($domain) ?></h3>
        <textarea id="ta_<?= md5($domain) ?>"><?= implode("\n", $links) ?></textarea>
        <button onclick="copyText('ta_<?= md5($domain) ?>')">Copy All Links</button>
      <?php endforeach; ?>
    <?php endif; ?>

    <?php if ($errors): ?>
      <div class="error">
        <strong>Errors:</strong>
        <ul>
          <?php foreach ($errors as $e): ?>
            <li><?= htmlspecialchars($e) ?></li>
          <?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>
  <?php endif; ?>
</div>

<script>
function copyText(id) {
  const ta = document.getElementById(id);
  ta.select();
  document.execCommand('copy');
  alert('Copied to clipboard!');
}
</script>
</body>
</html>
